
clear 
close all
clc

%% read compression

A = double(imread('cr.bmp'));
%A = double(imread('paolina.tif'));

[m,n] = size(A);

figure; imagesc(A); colormap gray

%% SVD

[U,S,V] = svds(A, 50); %only top 50 directions

s = diag(S);
figure; plot(s, '.'); title('Singular values')

figure; plot(cumsum(s.^2)/norm(A,'fro')^2, '.'); title('Explained variance')

%% display approximations
A_approx = zeros(m, n, 30);
for i = 1:30
    A_approx(:,:,i) = U(:,1:i) * S(1:i,1:i) * V(:,1:i)'; % not the efficient way
end
A_approx(:,:,end+1) = A;

figure; DisplayImageCollection(A_approx);